//---------------------------------------------------------------------------
#ifndef fclassH
#define fclassH
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#define	RAW_SCALE			1.
#define	FMOD_SCALE			3.5
#define	FARG_SCALE			M_PI
#define	COSINE_SCALE		8.5
#define	COSINE_SCALE2		400

#define	MAX_FACES			55
#define	MAX_SAMPLES			66
#define	MAX_SAMPLE_SIZE		(92*112*2)

void addslash(char *s);
void mkaddslash(char *d, const char *s);

template <class F> class CClassSet;
typedef CClassSet<char> CFaceImg;

class CFaceSample {
	public:
		char name[128];
		bool training;
		bool modified;
		AnsiString Name() { if(training) return AnsiString(name)+" *"; else return name; }
};

class CFace {
	protected:
		CFaceSample sample[MAX_SAMPLES];
	public:
		inline CFaceSample & operator [] (int i) { return sample[i]; }
		int count, original_count, modified_count;
		char name[32];
		bool training;
		bool negative;
		AnsiString Name() { if(negative) return AnsiString(name)+" #"; else if(training) return AnsiString(name)+" *"; else return name; }
//		{ return negative ? (AnsiString(name)+" --") : (training ? AnsiString(name)+" *" : AnsiString(name)); }
};

enum eDBType { dbORL, dbBMP, dbOWN, dbWAVSKEL };
enum eInputType { itRAW };

class CFaceDB {
	protected:
		CFace face[MAX_FACES];
	public:
		inline CFace & operator [] (int i) { return face[i]; }
		int count;
		int samples;
		struct ClassSample { int face, sample; float rmse; } order[MAX_FACES*MAX_SAMPLES];

		CFaceDB(CFaceImg * _pfi = NULL) : pfi(_pfi) { face_bmp = new Graphics::TBitmap; }
		~CFaceDB() { delete face_bmp; }

		int dbtype;
		int scale;
		int division;
		int drawscale;
		int input_type;
		int
			width,
			height,
			start_width,
			start_height;
		int
			sample_size,
			start_sample_size;
		CFaceImg * pfi;
		Graphics::TBitmap * face_bmp;

		int training_faces_percent, training_samples_percent;
		bool classic_division;

		void calc_samplesize(char *fn);
		int load_bmp(char *fn, unsigned char *buf);
		int load_pgm(char *fn, unsigned char *buf);
		void mirrorface(unsigned char *buf);
		void mirror_all_faces();
		int loadface(char *fn, unsigned char *buf);
		void load(char *dir);
		void init_order();
		void shuffle();
		void set_division_percentage();
		void divide_whole_set();
		void divide_one_face(int i);
		void calculate_input();
};

template <class F> class CClassSet {
	protected:
		F * sample[MAX_FACES][MAX_SAMPLES];
		CFaceDB * pfdb;
	public:
		int is_free;
		int sample_size;

		inline F ** operator [] (int i) { return sample[i]; }

		CClassSet(CFaceDB * _pfdb) : pfdb(_pfdb), is_free(1) { memset(sample, 0, sizeof(sample)); }
		CClassSet(CFaceDB * _pfdb, int _sample_size) : pfdb(_pfdb), is_free(1) { alloc(_sample_size); };
		~CClassSet() { free(); }

		void alloc(int _sample_size = -1)
		{
			int i, j;
			sample_size = _sample_size;

			free();
			memset(sample, 0, sizeof(sample));
			if(sample_size < 0)
				sample_size = pfdb->sample_size;
//			for(i = 0; i < pfdb->count; i++)
//				for(j = 0; j < (*pfdb)[i].count; j++)
			for(i = 0; i < MAX_FACES; i++)
				for(j = 0; j < MAX_SAMPLES; j++)
					sample[i][j] = new F[sample_size];
			is_free = 0;
		}
		void free()
		{
			int i, j;
			if(is_free)
				return;
			for(i = 0; i < MAX_FACES && sample[i][0]; i++)
				for(j = 0; j < MAX_SAMPLES && sample[i][j]; j++)
//			for(i = 0; i < pfdb->count; i++)
//				for(j = 0; j < (*pfdb)[i].count; j++)
					delete sample[i][j];
			memset(sample, 0, sizeof(sample));
			is_free = 1;
		}
};

#endif
