//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include <stdio.h>
#include <io.h>
#include <dir.h>
#include <dos.h>
#include <mem.h>

#include "fclass.h"
#include "fourier.h"

CFaceDB facedb;
CFaceImg faceimg(&facedb);
CClassSet<float> fraw(&facedb);
float w_input_scale = 1;

void addslash(char *s) {
	if(s[strlen(s)-1] != '\\')
		strcat(s, "\\");
}

void mkaddslash(char *d, const char *s) {
	strcpy(d, s);
	addslash(d);
}

void CFaceDB::calc_samplesize(char *fn)
{
	if(dbtype == dbORL) {
		width = 92;
		height = 112;
	} else {
		try { face_bmp->LoadFromFile(fn); }
		catch(...) { return; }
		width = face_bmp->Width;
		height = face_bmp->Height;
	}

	start_width = width;
	start_height = height;
	width >>= scale;
	height >>= scale;
	sample_size = width*height;
	start_sample_size = start_width*start_height;
	pfi->alloc(sample_size);
}

int CFaceDB::load_bmp(char *fn, unsigned char *buf)
{
	try { face_bmp->LoadFromFile(fn); }
	catch(...) { return -1; }

	for(int y = 0; y < start_height; y++)
		for(int x = 0; x < start_width; x++)
//			MainForm->FacePaintBox->Canvas->Pixels[x][y] =
			if(dbtype == dbWAVSKEL)
				*(buf++) = ((unsigned char)(face_bmp->Canvas->Pixels[x][y]&0X1))<<7;
			else
				*(buf++) = ((unsigned char)(face_bmp->Canvas->Pixels[x][y]&0XFF));

	return 0;
}

int CFaceDB::load_pgm(char *fn, unsigned char *buf)
{
	FILE *f = fopen(fn, "rb");

	if(!f)
		return -1;
	fseek(f, -start_sample_size, SEEK_END);
	fread(buf, 1, start_sample_size/*filelength(fileno(f))*/, f);
	fclose(f);

	return 0;
}

void CFaceDB::mirrorface(unsigned char *out_buf)
{
	int i, j;
	char c;

	for(i = 0; i < height; i++, out_buf += width)
		for(j = 0; j < (width>>1); j++)
		{
			c = out_buf[j];
			out_buf[j] = out_buf[width-j-1];
			out_buf[width-j-1] = c;
		}
}

int CFaceDB::loadface(char *fn, unsigned char *out_buf)
{
	int i, j, di, dj, r;
	unsigned avg;
	unsigned char scaled[MAX_SAMPLE_SIZE], buf[MAX_SAMPLE_SIZE];

	if(dbtype == dbORL)
		r = load_pgm(fn, buf);
	else
		r = load_bmp(fn, buf);
	if(r)
		return -1;

	if(scale)
	{
		for(j = 0; j < height; j++)
			for(i = 0; i < width; i++)
			{
				avg = 0;
				for(dj = j<<scale; dj < (j+1)<<scale; dj++)
					for(di = i<<scale; di < (i+1)<<scale; di++)
						avg += buf[dj*start_width+di];
				avg >>= (1<<scale);
				scaled[j*width+i] = avg;
			}
		memcpy(out_buf, scaled, width*height);
	}
	else
		memcpy(out_buf, buf, sample_size);

	return 0;
}

void CFaceDB::load(char *dir)
{
	char path[1024], subdir[1024], fpath[1024], *fppos;
	struct ffblk ff, sff;
	int res, sres;

	width = -1;
	height = -1;
	sample_size = -1;

	strcpy(path, dir);
	addslash(path);
	strcat(path, "*.*");

	count = samples = 0;
	for(res = findfirst(path, &ff, FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_DIREC|FA_ARCH); !res; res = findnext(&ff))
		if(*ff.ff_name != '.' && ff.ff_attrib&FA_DIREC)
		{
			strcpy(face[count].name, ff.ff_name);
			face[count].count = 0;
			mkaddslash(subdir, dir);
			strcat(subdir, ff.ff_name);
			addslash(subdir);
			strcpy(fpath, subdir);
			fppos = strchr(fpath, 0);
			if(dbtype == dbOWN)
				strcat(subdir, "*HB*.bmp");
			else if(dbtype == dbBMP || dbtype == dbWAVSKEL)
				strcat(subdir, "*.bmp");
			else
				strcat(subdir, "*.pgm");
			for(sres = findfirst(subdir, &sff, FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_DIREC|FA_ARCH); !sres; sres = findnext(&sff))
				if(!(sff.ff_attrib&FA_DIREC))
				{
					strcpy(fppos, sff.ff_name);
					strcpy(face[count][face[count].count].name, sff.ff_name);
					if(sample_size == -1)
						calc_samplesize(fpath);
					if(!loadface(fpath, (*pfi)[count][face[count].count]))
					{
						face[count][face[count].count].modified = false;
						face[count].count++;
					}
				}
			face[count].negative = false;
			samples += face[count].count;
			face[count].original_count = face[count].modified_count = face[count].count;
			if(face[count].count)
				count++;
		}

//	if(MainForm->MirrorImages->Checked)
//		mirror_all_faces();

	init_order();
}

void CFaceDB::mirror_all_faces()
{
	for(int i = 0; i < count; i++)
	{
		for(int j = 0; j < face[i].count; j++)
		{
			strcpy(face[i][j+face[i].count].name, face[i][j].name);
			strcat(face[i][j+face[i].count].name, " mirrored");
			face[i][j+face[i].count].modified = true;
			memcpy((*pfi)[i][j+face[i].count], (*pfi)[i][j], sample_size);
			mirrorface((*pfi)[i][j+face[i].count]);
		}
		face[i].count <<= 1;
		face[i].modified_count = face[i].count;
	}
}

void CFaceDB::init_order()
{
	int i, j;
	for(i = 0, samples = 0; i < count; i++)
		for(j = 0; j < face[i].count; j++, samples++)
		{
			order[samples].face = i;
			order[samples].sample = j;
			order[samples].rmse = 0;
		}
}

void CFaceDB::shuffle()
{
	int i, k;
	ClassSample cs;

	for(k = 0; k < samples; k++)
	{
		i = random(samples);
		cs = order[k];
		order[k] = order[i];
		order[i] = cs;
	}
}

void CFaceDB::set_division_percentage()
{
//	int division = 6;

	switch(division)
	{
		case 0: training_faces_percent = training_samples_percent = 1024; break;
		case 1: training_faces_percent = 512; training_samples_percent = 1024; break;
		case 6:
		case 7:
		case 2: training_faces_percent = 1024; training_samples_percent = 512; break;
		case 3: training_faces_percent = training_samples_percent = 512; break;
		case 4: training_faces_percent = 1024; training_samples_percent = 1024*0.33; break;
		case 5: training_faces_percent = 1024; training_samples_percent = 1024*0.73; break;
	}
	classic_division = division == 6;
}

void CFaceDB::divide_whole_set()
{
	int i, j, ii, tfc, nfc;

	for(i = 0; i < count; i++)
	{
		face[i].training = false;
		face[i].negative = false;
		for(j = 0; j < face[i].count; j++)
			face[i][j].training = false;
	}

	tfc = count*training_faces_percent/1024;
	if(count&1 && tfc < count)
		tfc++;

	for(ii = 0; ii < tfc; ii++)
	{
		//for(i = random(face_count); face[i].tf; i == face_count?i=0:i++);
		do i = random(count); while(face[i].training);
		face[i].training = true;
		face[i].negative = false;
		divide_one_face(i);
	}

#define	negative_faces_percent	0//512
	nfc = tfc*negative_faces_percent/1024;
	for(ii = 0; ii < nfc; ii++)
	{
		do i = random(count); while(!(face[i].training && !face[i].negative));
		face[i].negative = true;
		divide_one_face(i);
	}
}

void CFaceDB::divide_one_face(int i)
{
	int j, jj, tsc;

	if(classic_division) {
		for(j = 0; j < face[i].count; j++)
			face[i][j].training =
				(face[i][j].name[0] == '1' || face[i][j].name[0] == '2' ||
				face[i][j].name[0] == '3' || face[i][j].name[0] == '4' ||
				face[i][j].name[0] == '5')
				&& face[i][j].name[1] != '0';
//			face[i][j].training = (j < (face[i].count>>1)+1+MainForm->MirrorImages->Checked) && strncmp(face[i][j].name, "10", 2) != 0;
	} else if(face[i].negative) {
		for(j = 0; j < face[i].count; j++)
			face[i][j].training = true;
	} else {
		tsc = face[i].count*training_samples_percent/1024;
		if(face[i].count&1 && tsc < face[i].count)
			tsc++;
		for(jj = 0; jj < tsc; jj++)
		{
			//for(j = random(face[i].sample_count); face[i].ts[j]; j == face[i].sample_count?j=0:j++);
			do j = random(face[i].original_count); while(face[i][j].training);
			face[i][j].training = true;
			if(face[i].original_count < face[i].modified_count)
				for(int k = j+face[i].original_count; k < face[i].modified_count; k += face[i].original_count)
				{
					face[i][k].training = true;
					jj++;
				}

/*			if(MainForm->MirrorImages->Checked)
				if(!face[i][j].modified && !face[i][j+1].training) {
					face[i][j+1].training = true;
					jj++;
				} else if(face[i][j].modified && !face[i][j-1].training) {
					face[i][j-1].training = true;
					jj++;
				}
*/		}
	}
}

void CFaceDB::calculate_input()
{
	int i, j;

	fraw.alloc();
	for(i = 0; i < count; i++)
		for(j = 0; j < face[i].count; j++)
			scale_char_image(width, height, (*pfi)[i][j], fraw[i][j], 128, RAW_SCALE*w_input_scale);
}

//---------------------------------------------------------------------------
